
#ifndef _COMMON_H_
#define _COMMON_H_

#include <stdio.h>
#include "AD18F08.h"


/*********************************************中断设置**************************************/
#define           H_SysPri_INIT_EN       0  //使能高优先级中断
#define           H_SysPri_INIT_Dis      1  //禁用高优先级中断
#define           L_SysPri_INIT_EN       2  //使能低优先级中断
#define           L_SysPri_INIT_Dis      3  //禁用低优先级中断

#define           INT_OFF                0  //禁用外设中断
#define           H_Pri_INT              1  //外设使能高优先级中断
#define           L_Pri_INT              2  //外设使能低优先级中断
/*********************************************中断设置**************************************/

/**********************************************TIMER*****************************************/
#define           T0_CLK_EN            1    //使能TIMER0
#define           T0_CLK_DIS           0    //禁用TIMER0

#define           T0_FOSC_2            0    //TIMER0预分频为2
#define           T0_FOSC_4            1    //TIMER0预分频为4
#define           T0_FOSC_8            2    //TIMER0预分频为8
#define           T0_FOSC_16           3    //TIMER0预分频为16
#define           T0_FOSC_32           4    //TIMER0预分频为32
#define           T0_FOSC_64           5    //TIMER0预分频为64
#define           T0_FOSC_128          6    //TIMER0预分频为128
#define           T0_FOSC_256          7    //TIMER0预分频为256

#define           T0_CS_CPU            0    //TIMER0时钟源为CPU 运行时钟
#define           T0_CS_T0CK1          1    //TIMER0时钟源为T0CKI(PA5)
#define           T0_CS_2K             2    //TIMER0时钟源为内部2K
#define           T0_CS_CMPOUT         3    //TIMER0时钟源是CMPOUT输出

#define           T0_EN_NFD            1    //使能TIMER0的时钟且不分频
#define           T0_EN_FD             0    //使能TIMER0的时钟源分频

#define           T0_INT_EN            1    //使能TIMER0中断
#define           T0_INT_DIS           0    //禁止TIMER0中断

// #define           T0_COUNT_P           0    //T0CKI脚上降沿触发计数
// #define           T0_COUNT_N           1    //T0CKI脚下降沿触发计数  
// #define           T0_BUZZEE_EN         1    //启动BUZZEE模式
// #define           T0_BUZZEE_DIS        0    //禁止BUZZEE模式


void GPIO_Init(void);
void timer0_Count(void);
void timer0_BUZZEE(unsigned char model);

void Timer0_Timer(unsigned char T0_CS,unsigned char T0_CY,unsigned char T0_CV,unsigned char CS_EN,unsigned char T0_FD,unsigned char Pri_INT);
/*******************************************************************************
*  Function: timer0 定时
*  Parameters：
*
*                     
*
*  T0_CS  （时钟源）：    
*                       T0_CS_CPU            0    //TIMER0时钟源为CPU 运行时钟
*                       T0_CS_T0CK1          1    //TIMER0时钟源为T0CKI(PA5)
*                       T0_CS_2K             2    //TIMER0时钟源为内部2K
*                       T0_CS_CMPOUT         3    //TIMER0时钟源是CMPOUT输出
*
*  T0_CY  （周期）：     0~255
*
*  T0_CV  （计数值）：   0~255
*
*  CS_EN （分频使能）： 
*                       T0_EN_FD             0    //使能TIMER0的时钟源分频
*                       T0_EN_NFD            1    //使能TIMER0的时钟且不分频
*
*  FD   （分频数）：
*                       T0_FOSC_2            0    //TIMER0预分频为2
*                       T0_FOSC_4            1    //TIMER0预分频为4
*                       T0_FOSC_8            2    //TIMER0预分频为8
*                       T0_FOSC_16           3    //TIMER0预分频为16
*                       T0_FOSC_32           4    //TIMER0预分频为32
*                       T0_FOSC_64           5    //TIMER0预分频为64
*                       T0_FOSC_128          6    //TIMER0预分频为128
*                       T0_FOSC_256          7    //TIMER0预分频为256
*                    
*  Pri_INT  （中断使能）： 
*                       INT_OFF                0  //禁用外设中断
*                       H_Pri_INT              1  //外设使能高优先级中断
*                       L_Pri_INT              2  //外设使能低优先级中断
*******************************************************************************/

void timer0_Buzzer(unsigned char T0_CS,unsigned char T0_CY,unsigned char T0_CV,unsigned char CS_EN,unsigned char T0_FD);
/*******************************************************************************
*  Function: timer0 Buzzer  模式输出是一个1/2占空比信号。当TMR0溢出时输出一个方波，中断间隔时间频率2分频后作为Buzzer输出的频率。
*  Parameters：
*
*
*  T0_CS  （时钟源）：    
*                       T0_CS_CPU            0    //TIMER0时钟源为CPU 运行时钟
*                       T0_CS_T0CK1          1    //TIMER0时钟源为T0CKI(PA5)
*                       T0_CS_2K             2    //TIMER0时钟源为内部2K
*                       T0_CS_CMPOUT         3    //TIMER0时钟源是CMPOUT输出
*
*  T0_CY  （周期）：     0~255
*
*  T0_CV  （计数值）：   0~255
*
*  CS_EN （分频使能）： 
*                       T0_EN_FD             0    //使能TIMER0的时钟源分频
*                       T0_EN_NFD            1    //使能TIMER0的时钟且不分频
*
*  FD   （分频数）：
*                       T0_FOSC_2            0    //TIMER0预分频为2
*                       T0_FOSC_4            1    //TIMER0预分频为4
*                       T0_FOSC_8            2    //TIMER0预分频为8
*                       T0_FOSC_16           3    //TIMER0预分频为16
*                       T0_FOSC_32           4    //TIMER0预分频为32
*                       T0_FOSC_64           5    //TIMER0预分频为64
*                       T0_FOSC_128          6    //TIMER0预分频为128
*                       T0_FOSC_256          7    //TIMER0预分频为256               
*******************************************************************************/


void System_INIT_Config(unsigned char INT_cfg);
/*******************************************************************************
* Description    : 设置系统优先级总中断
* Input          : [INT_cfg]:   
*                            H_SysPri_INIT_EN : 使能高优先级中断
*                            H_SysPri_INIT_Dis: 禁用高优先级中断
*                            L_SysPri_INIT_EN : 使能低优先级中断
*                            L_SysPri_INIT_Dis: 禁用低优先级中断
* Return         : None.
* Note           : None.
*******************************************************************************/







#endif